/**
  ******************************************************************************
  * @file    iwdg_interface.c
  * @author  MCD Application Team
  * @brief   Contains IWDG HW configuration
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "platform.h"
#include "wwdg_interface.h"
#include "openbl_core.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static WWDG_HandleTypeDef WWDGHandle;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

void OPENBL_WWDG_Configuration(void)
{
  WWDGHandle.Instance = WWDG;
  WWDGHandle.Init.Prescaler = WWDG_PRESCALER_8;
  WWDGHandle.Init.Window    = 0x7F;
  WWDGHandle.Init.Counter   = 0x7F;
  WWDGHandle.Init.EWIMode   = WWDG_EWI_DISABLE;

  /* Set WWDG Counter */
  WRITE_REG(WWDG->CR, WWDGHandle.Init.Counter);

  /* Set WWDG Prescaler and Window */
  WRITE_REG(WWDG->CFR, (WWDGHandle.Init.EWIMode | WWDGHandle.Init.Prescaler | WWDGHandle.Init.Window));

  OPENBL_WWDG_Refresh();
}

void OPENBL_WWDG_Refresh(void)
{
  HAL_WWDG_Refresh(&WWDGHandle);
}

static const OPENBL_OpsTypeDef WWDG_Ops =
{
  .Init = OPENBL_WWDG_Configuration,
  .DeInit = NULL,
  .Detection = NULL,
  .CommandProcess = NULL,
};

static const OPENBL_IOTypeDef WWDG_IO =
{
  .Read = NULL,
  .Write = NULL,
};

OPENBL_HandleTypeDef WWDG_Handle =
{
  .p_Ops = &WWDG_Ops,
  .p_IO = &WWDG_IO,
};

/************************ (C) COPYRIGHT Puya *****END OF FILE****/
